### **Configuration Steps**

#### **1. Enable IKE on an Interface**

- Enable IKEv1, IKEv2, or both on the interface that serves as the VPN termination point.

---

#### **2. Create a Connection Profile**

- A connection profile combines all required IPsec components. Key elements include:
    - **IKE Policy**: Defines negotiable IKE SA parameters (e.g., encryption, integrity, PRF algorithms, DH group).
    - **IPsec Transform Set/Proposal**: Specifies IPsec SA parameters (e.g., encryption and integrity algorithms).
    - **Crypto ACL**: Identifies traffic to be encrypted.
    - **Crypto Map**: Combines the IPsec transform set, crypto ACL, and VPN peer's IP address.
    - **Tunnel Group**: Configures authentication and default group policy.
- Example:
    - Name of connection profile matches the VPN peer's IP address (used as the IKE identity by default).
    - Applied to the outside interface.
    - Protected local and remote networks are defined as network objects.
    - Enabled for IKEv2 only.

---

#### **3. Configure NAT Exemption**

- Ensure VPN traffic bypasses NAT rules to avoid translation.
- Use **Manual NAT Configuration** in the NAT table:
    - **Original Packet**: Specify local protected network as the source and remote network as the destination.
    - **Translated Packet**: Set source and destination to "Original" to prevent translation.
    - Use **Static Translation** for bidirectional traffic.

---

#### **4. Configure Routing**

- Ensure the appliance knows how to reach remote networks:
    - If VPN traffic is terminated on the **outside interface** and a default route exists, no additional routing configuration is needed.
    - If VPN traffic is terminated on a different interface (e.g., WAN or ISP-dedicated), configure a specific static route pointing to the VPN-enabled interface.

---

### **Verification and Troubleshooting**

#### **1. Verify ACLs**

- Ensure VPN traffic is allowed by interface ACLs:
    - Use `show logging` or `show access-list` commands.
    - Use **Cisco ASDM Real-Time Log Viewer** or **Packet Tracer** to determine if traffic matches ACLs or is being dropped.

#### **2. Verify NAT**

- Check that VPN traffic is not being translated:
    - Use `show nat` and `show xlate` commands.
    - Use **Packet Tracer** to identify NAT rules affecting VPN traffic.

#### **3. Verify Routing**

- Ensure a valid route exists for remote networks:
    - Use `show route` to determine the egress interface for VPN traffic.
    - Use **Packet Tracer** to confirm the correct route rules.

#### **4. Verify IKE Security Associations (SA)**

- Ensure the IKE SA is established:
    - Use `show crypto ikev2 sa` to check SA status.
    - If SA is not established, verify IKE authentication and parameter configurations.

#### **5. Verify IPsec Security Associations (SA)**

- Ensure IPsec SAs are established and traffic is being encrypted/decrypted:
    - Use `show crypto ipsec sa` to verify.
    - If SAs are not established, check IPsec parameters.

---

### **Additional Notes**

- Cisco Secure Firewall ASA bypasses interface ACLs for VPN traffic by default. If this behavior changes, ensure ACLs explicitly allow VPN traffic.
- Common troubleshooting tools include:
    - **Packet Tracer**: To simulate and analyze traffic matching ACLs, NAT, and routing rules.
    - **ASDM Real-Time Log Viewer**: For real-time monitoring of logs and traffic behavior.